//
//  MCMetaDataManager.h
//  MCApplication
//
//  Created by Ali Lalani on 03/05/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPObjectContext;
@class MCUserDefaults;

@interface MCMetaDataManager : NSObject {
	NSMutableDictionary *_entities;   // configurations for each entity that spotlight should know/care about
	NSString *_metaDataStorePath;     // where are all these little files kept?
	NSString *_uniqueID;              // each database has a unique id, this is what we name the directory we keep the metadata store in

	MCPObjectContext *_objectContext; // this is for syncing purposes

	MCUserDefaults *_userDefaults;
	
	// if we're running on Tiger, this is a yes, but it could be a no if there was a preference for it or something...
	BOOL shouldManageMetaData;

	BOOL _shouldSyncMetaData;
	
	id uiDelegate; // this is the delegate that might want to attach a UI to a sync.
}
- (id)initWithUniqueID:(NSString *)uid objectContext:(MCPObjectContext *)oc userDefaults:(MCUserDefaults *)defaults;

// A full sync of meta data
- (void)syncMetaDataWithProgressDelegate:(id)progressDelegate;
- (int)applicableObjectsCount;

// Updates a given object, if necessary
- (BOOL)updateObject:(id)obj;
// Deletes a given object, if necessary
- (BOOL)deleteObject:(id)obj;

// Here we check to make sure the dlm in the database is the same as the dlm on the store folder, if not, we re-sync the entire database
- (void)metaDataStoreWillChange;
// Here we set the dlm in the database to the dlm on the store folder
- (void)metaDataStoreDidChange;

// Returns the dictionary put in the store file that, in the importer we rip all the keys out of and directly pass to spotlight
- (NSDictionary *)metaDataDictionaryForObject:(id)obj configuration:(NSDictionary *)conf uid:(NSNumber *)uniqueID;

// specific accessing of attributes
- (NSDictionary *)configurationForEntityNamed:(NSString *)aName;
- (NSString *)extensionForEntityNamed:(NSString *)aName;
- (NSDictionary *)configurationForExtension:(NSString *)ext;

// general setting of entity configurations
- (void)registerEntities:(NSArray *)array;
- (void)registerEntity:(NSDictionary *)dict;

// accessors
- (NSMutableDictionary *)entities;
- (void)setEntities:(NSMutableDictionary *)anEntities;

- (NSString *)metaDataStorePath;
- (void)setMetaDataStorePath:(NSString *)aMetaDataStorePath;

- (NSString *)uniqueID;
- (void)setUniqueID:(NSString *)anUniqueID;

- (MCPObjectContext *)objectContext;
- (void)setObjectContext:(MCPObjectContext *)anObjectContext;

- (MCUserDefaults *)userDefaults;
- (void)setUserDefaults:(MCUserDefaults *)anUserDefaults;

- (BOOL)shouldSyncMetaData;
- (void)setShouldSyncMetaData:(BOOL)flag;
@end

@interface NSObject (MetaDataManagerProgressDelegate)
- (void)syncWillStartWithCount:(int)resultCount;
- (void)syncWillProgressWithCurrentCount:(int)currentCount;
- (void)syncWillEnd;
@end
